<?php

namespace App\Http\Controllers;

use App\Models\Kategori;
use App\Models\Satuan;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class IndukController extends Controller
{
    public function kategori(): View
    {
        $kategori = Kategori::latest('id', 'DESC')->get();
        $data = [
            'title' => 'Ramizah Store | Kategori',
            'page' => 'Kategori',
            'menuActive' => 'kategori',
            'menuOpen' => 'induk',
        ];
        return view('admin.induk.kategori', compact('data', 'kategori'))->with('no', 1);
    }

    public function input_kategori(Request $request): RedirectResponse
    {
        $request->validate(
            [
                'nm_kategori'  => 'required|unique:kategoris,nm_kategori',
                'keterangan'   => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Kategori sudah pernah diinputkan, silahkan input Kategori lain!',
            ]
        );

        Kategori::create([
            'nm_kategori'         => $request->nm_kategori,
            'ktr_kategori'   => $request->keterangan,
        ]);

        return redirect()->route('kategori')->with(['success' => 'Data Berhasil Disimpan!']);
    }

    public function update_kategori(Request $request): RedirectResponse
    {
        if ($request->nmlama != $request->nm_kategori) {
            $rule =  'required|unique:kategoris,nm_kategori';
        } else {
            $rule = 'required';
        }

        $request->validate(
            [
                'nm_kategori'   => $rule,
                'keterangan'           => 'required'
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Judul kategori sudah pernah diinputkan, silahkan input Judul  lain!',
            ]
        );

        $id = $request->id;
        $kategori = Kategori::findOrFail($id);

        $kategori->update([
            'nm_kategori'    => $request->nm_kategori,
            'ktr_kategori'        => $request->keterangan,
        ]);

        return redirect()->route('kategori')->with(['success' => 'Data Berhasil Diubah!']);
    }

    public function hapus_kategori($id)
    {
        Kategori::findOrFail($id)->delete();
        return redirect()->route('kategori')->with(['success' => 'Data Berhasil Dihapus!']);
    }

    public function satuan(): View
    {
        $satuan = Satuan::latest('id', 'DESC')->get();
        $data = [
            'title' => 'Ramizah Store | Satuan',
            'page' => 'Satuan',
            'menuActive' => 'satuan',
            'menuOpen' => 'induk',
        ];
        return view('admin.induk.satuan', compact('data', 'satuan'))->with('no', 1);
    }

    public function input_satuan(Request $request): RedirectResponse
    {
        $request->validate(
            [
                'nm_satuan'  => 'required|unique:satuans,nm_satuan',
                'keterangan'   => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Sataun sudah pernah diinputkan, silahkan input username lain!',
            ]
        );

        Satuan::create([
            'nm_satuan'         => $request->nm_satuan,
            'ktr_satuan'   => $request->keterangan,
        ]);

        return redirect()->route('satuan')->with(['success' => 'Data Berhasil Disimpan!']);
    }

    public function update_satuan(Request $request): RedirectResponse
    {
        if ($request->nmlama != $request->nm_satuan) {
            $rule =  'required|unique:satuans,nm_satuan';
        } else {
            $rule = 'required';
        }

        $request->validate(
            [
                'nm_satuan'   => $rule,
                'keterangan'           => 'required'
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Judul Satuan sudah pernah diinputkan, silahkan input Judul  lain!',
            ]
        );

        $id = $request->id;
        $satuan = Satuan::findOrFail($id);

        $satuan->update([
            'nm_satuan'         => $request->nm_satuan,
            'ktr_satuan'   => $request->keterangan,
        ]);

        return redirect()->route('satuan')->with(['success' => 'Data Berhasil Diubah!']);
    }

    public function hapus_satuan($id)
    {
        Satuan::findOrFail($id)->delete();
        return redirect()->route('satuan')->with(['success' => 'Data Berhasil Dihapus!']);
    }
}
